﻿// Startup.cs
// Katana (OWIN) + Azure AD sign-in + Microsoft Graph delegated Mail.Send
// Stores Graph access token into ASP.NET Session so Wisej can import it into Wisej Session.

using Microsoft.Owin;
using Microsoft.Owin.Host.SystemWeb;
using Microsoft.Owin.Security;
using Microsoft.Owin.Security.Cookies;
using Microsoft.Owin.Security.OpenIdConnect;
using Owin;
using System;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;

[assembly: OwinStartup(typeof(AppName.Startup))]

namespace AppName
{
    public class Startup
    {
        // ASP.NET Session keys (Wisej will copy these to Wisej.Web.Application.Session)
        public const string AspNetSessionGraphAccessTokenKey = "GraphAccessToken";
        public const string AspNetSessionGraphOidKey = "GraphOid";

        public void Configuration(IAppBuilder app)
        {
            app.SetDefaultSignInAsAuthenticationType(CookieAuthenticationDefaults.AuthenticationType);

            app.UseCookieAuthentication(new CookieAuthenticationOptions
            {
                AuthenticationType = CookieAuthenticationDefaults.AuthenticationType,

                // Helps in System.Web hosting
                CookieManager = new SystemWebCookieManager(),

                SlidingExpiration = true,
                ExpireTimeSpan = TimeSpan.FromHours(8)
            });

            app.UseOpenIdConnectAuthentication(new OpenIdConnectAuthenticationOptions
            {
                ClientId = GlobalVars.ClientId,
                ClientSecret = GlobalVars.ClientSecret,   // ✅ ADD THIS
                Authority = GlobalVars.Authority,
                RedirectUri = GlobalVars.RedirectUri,
                CallbackPath = new PathString("/signin-oidc"),
                PostLogoutRedirectUri = GlobalVars.PostLogoutRedirectUri,

                SignInAsAuthenticationType = CookieAuthenticationDefaults.AuthenticationType,
                ResponseType = "code",
                Scope = "openid profile offline_access https://graph.microsoft.com/Mail.Send",
                RedeemCode = true,

                Notifications = new OpenIdConnectAuthenticationNotifications
                {
                    TokenResponseReceived = n =>
                    {
                        var accessToken = n.TokenEndpointResponse?.AccessToken;
                        var ctx = System.Web.HttpContext.Current;
                        if (ctx?.Session != null && !string.IsNullOrWhiteSpace(accessToken))
                            ctx.Session["GraphAccessToken"] = accessToken;

                        return Task.FromResult(0);
                    },
                    AuthenticationFailed = n =>
                    {
                        n.HandleResponse();
                        n.Response.Redirect(GlobalVars.AppBaseUrl +
                            "/?authError=" + Uri.EscapeDataString(n.Exception.Message));
                        return Task.FromResult(0);
                    }
                }
            });

        }
    }
}
