﻿using Microsoft.Owin.Security;
using Microsoft.Owin.Security.OpenIdConnect;
using System;
using System.Web;

namespace AppName
{
    public partial class AuthLogin : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            var returnUrl = Request.QueryString["returnUrl"];
            if (string.IsNullOrWhiteSpace(returnUrl))
                returnUrl = GlobalVars.AppBaseUrl;

            if (Request.IsAuthenticated)
            {
                Response.Redirect(returnUrl);
                return;
            }

            HttpContext.Current.GetOwinContext().Authentication.Challenge(
                new AuthenticationProperties { RedirectUri = returnUrl },
                OpenIdConnectAuthenticationDefaults.AuthenticationType
            );
        }
    }
}
