﻿using System.Security.Claims;
using System.Web;
using Wisej.Web;

namespace AppName
{

    public static class WisejGraphToken
    {
        private const string WisejKey = "GraphAccessToken";

        public static void ImportFromAspNetSession()
        {
            var ctx = HttpContext.Current;
            if (ctx == null || ctx.Session == null)
                return;

            var token = ctx.Session[Startup.AspNetSessionGraphAccessTokenKey] as string;
            if (!string.IsNullOrWhiteSpace(token))
            {
                Application.Session[WisejKey] = token;
                ctx.Session.Remove(Startup.AspNetSessionGraphAccessTokenKey);
            }
        }

        public static string Get()
        {
            return Application.Session[WisejKey] as string;
        }
    }


    public static class WisejAuthUtil
    {
        public static ClaimsPrincipal GetClaimsPrincipal()
        {
            // 1) Best for Wisej callbacks
            var p1 = Application.User as ClaimsPrincipal;
            if (p1 != null)
                return p1;

            // 2) Normal ASP.NET request context (may be null in callbacks)
            var p2 = HttpContext.Current?.User as ClaimsPrincipal;
            if (p2 != null)
                return p2;

            // 3) OWIN context (only if HttpContext exists)
            var owinUser = HttpContext.Current?.GetOwinContext()?.Authentication?.User as ClaimsPrincipal;
            return owinUser;
        }

        public static bool IsAuthenticated()
        {
            // Wisej’s own flag is the most reliable in Wisej runtime
            if (Application.IsAuthenticated)
                return true;

            var p = GetClaimsPrincipal();
            return p?.Identity?.IsAuthenticated == true;
        }
    }

    public static class GraphSession
    {
        private const string Key = "GraphAccessToken";

        public static bool HasToken()
        {
            return !string.IsNullOrWhiteSpace(Application.Session[Key] as string);
        }

        public static string GetToken()
        {
            return Application.Session[Key] as string;
        }
    }

    public static class LoginFlow
    {
        public static void EnsureLoggedIn()
        {
            if (GraphSession.HasToken())
                return;

            // optional: keep return URL
            var returnUrl = Application.Url ?? "/";
            var url = "/AuthLogin.aspx?returnUrl=" + HttpUtility.UrlEncode(returnUrl);

            Application.Navigate(url);
        }
    }

}