﻿using iTextSharp.text.pdf;
using System;
using System.Collections.Generic;
using System.IO;
using Wisej.Web;
using zagar;
using static System.Net.WebRequestMethods;

namespace eDigital
{
    public partial class frmBEJ : Form
    {
        public frmBEJ()
        {
            InitializeComponent();
        }

        private void frmBEJ_Load(object sender, EventArgs e)
        {
            lblInstructiuni.Text = utils.GetParamValue("instructiuni_bej", "");

            u.Uploaded += U_Uploaded;
            u.AllowMultipleFiles = false;
            u.AllowedFileTypes = ".pdf";
            u.Visible = false;//initial trebuie sa fie true, altfel nu se creaza controlul in browser!!!
            cmdUploadCerere.AddClientEventListener("execute", "this.getParent().u.upload()");
        }

        private void cmdCancel_Click(object sender, EventArgs e)
        {
            Close();
        }

        private string verificaSemnatura(string fileNameFull)
        {
            var l = sign.GetCertificateFromSignedFile(fileNameFull);
            string rol = ((diverse)Application.Session.diverse).user.rol;
            if (((diverse)Application.Session.diverse).user.autenticated)
            {
                if (l.Count > 0) return "";
                return "Fisier nesemnat!";
            }
            else
            {
                if (l.Count == 0)
                    return "Fisier nesemnat!";
            }

            bool esteSemnatRol = false;
            for (int i = 0; i < l.Count; i++)
            {
                string cmd = "select count(*) from SEMNATURI_ROL where rol='" + rol + "' and semnatura='" + l[i].publicKey + "'";
                string nr = utils.ExecuteAndReturnData(cmd);
                if (nr != "0")
                {
                    esteSemnatRol = true;
                    //vedem cand a fost semnat, sa fie totusi recent
                    TimeSpan span = DateTime.Now - l[i].semnatLa;
                    if (span.TotalMinutes <= 120) return "";
                }
            }
            if (esteSemnatRol)
                return "Fisierul trimis este semnat de mai mult de 2 ore! Trimiteti un fisier semnat mai recent.";
            else
                return "Fisierul nu are semnaturi asociate rolului " + rol;

        }




        private void cmdUploadCerere_Click(object sender, EventArgs e)
        {
        }


        private void ShowWait(string mesaj = null)
        {
            if (mesaj != null) lblWait.Text = mesaj;
            lblWait.Visible = true;
            Application.Update(this);
        }
        private void HideWait()
        {
            lblWait.Visible = false;
            Application.Update(this);
        }

        private void U_Uploaded(object sender, UploadedEventArgs e)
        {
            if (e.Files.Count != 1)
            {
                MessageBox.Show("Puteti trimite un singur fisier!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            if (!e.Files[0].FileName.ToLower().EndsWith(".pdf"))
            {
                MessageBox.Show("Trimite un fisier PDF semnat!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            ShowWait("Asteptati prelucrarea datelor...");
            string idFisier = utils.ExecuteAndReturnData("select diverse_seq.nextval from dual");
            string cale = ((diverse)Application.Session.diverse).filesDirectory;
            string nf = System.IO.Path.Combine(cale, idFisier + "_" + utils.EliminareDiacritice(e.Files[0].FileName));
            e.Files[0].SaveAs(nf);

            //verificare semnatura
            string rez = "";
            if (!((diverse)Application.Session.diverse).user.autenticated) rez = verificaSemnatura(nf);
            if (rez != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(rez, "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            //campuri pdf
            int nrFields = 0;
            iTextSharp.text.pdf.PdfReader p = new iTextSharp.text.pdf.PdfReader(nf);
            AcroFields pdfFormFields = p.AcroFields;
            //verificare ca a semnat in campul corect - comentat Zagar 15.10.2024 pentru semnaturi cloud, care nu merg puse pe campul existent
            //List<string> blanks = p.AcroFields.GetBlankSignatureNames();
            //if (blanks.Count > 0)
            //{
            //    idFisier = "";
            //    HideWait();
            //    MessageBox.Show("Folositi campul de semnatura din fisier (clic pe el pentru a semna)!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
            //    return;
            //}
            //modificat dupa semnare?
            if (sign.EsteModificatDupaSemnare(nf) != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show("Fisierul a fost modificat dupa semnare!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            string dataCerere = "", campuri = "", listaCNP = "";
            //campurile
            foreach (var kvp in pdfFormFields.Fields)
            {
                nrFields++;
                string fieldName = kvp.Key.ToString();
                string fieldValue = pdfFormFields.GetField(kvp.Key.ToString());
                if (fieldName == "DATA") dataCerere = fieldValue;
                if (fieldValue != "") campuri += fieldName + "=" + fieldValue + ";";
                if (fieldName.StartsWith("CNPCUI") && fieldValue != "") { if (listaCNP != "") listaCNP += ","; listaCNP += fieldValue; }
            }

            string listaCNP1 = "", listaDosare1 = "";
            for (int i = 1; i <= 26; i++)
            {
                try
                {
                    string cnp = pdfFormFields.GetField("CNPCUIRow" + i.ToString());
                    string dosar = pdfFormFields.GetField("dosarRow" + i.ToString());
                    if (cnp != "" && dosar != "")
                    {
                        if (listaCNP1 != "") listaCNP1 += ","; listaCNP1 += cnp;
                        if (listaDosare1 != "") listaDosare1 += ","; listaDosare1 += dosar;
                    }
                }
                catch { }
            }
            utils.Log("CNPuri:" + listaCNP1);
            utils.Log("Dosare:" + listaDosare1);

            p.Close();
            //verificare data cererii=data curenta! (02.11.2020)
            if (dataCerere.Replace("/", ".").Replace("-", ".") != DateTime.Now.ToString("dd.MM.yyyy"))
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show("Data cererii (" + dataCerere + ") este diferita de data curenta!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //try { zagar.utils.Log(((diverse)Application.Session.diverse).user.cont, "Incarcare cerere BEJ", 5); } catch { }

            //creaza cerere stare initiala; id_tip_cerere=1 BEJ creat de mine manual
            string idUser = ((diverse)Application.Session.diverse).user.id;
            string idCerere = zagar.utils.ExecuteAndReturnData("select diverse_seq.nextval from dual");
            string cmd = "insert into cereri (id, rol, id_tip_cerere, data, creat_de, observatii, id_stare, id_user) values (" + idCerere + ", '" + ((diverse)Application.Session.diverse).user.rol + "', 1, sysdate,'" + ((diverse)Application.Session.diverse).user.nume + "', 'automat', 0, " + idUser + ")";
            zagar.utils.ExecuteSQL(cmd, false);
            if (zagar.utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(zagar.utils.lastError, "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            cmd = "insert into fisiere (id, nume, date_created, created_by, rol,campuri) values (" + idFisier + ", '" + idFisier + "_" + utils.EliminareDiacritice(e.Files[0].FileName) + "', sysdate, '" + ((diverse)Application.Session.diverse).user.nume + "', '" + ((diverse)Application.Session.diverse).user.rol + "','" + campuri + "')";
            utils.ExecuteSQL(cmd, false);
            if (utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(utils.lastError, "Eroare 1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //depunere document cerere ; 1=id_tip_document creat manual de mine in dic_documente
            cmd = "insert into cereri_documente (id, id_cerere, id_tip_document, id_fisier) values (diverse_seq.nextval, " + idCerere + ", 1, " + idFisier + ")";
            utils.ExecuteSQL(cmd, false);
            if (utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(utils.lastError, "Eroare 1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //actiunea de depunere document cerere ; asta da si numar din carnet
            cmd = "insert into cereri_actiuni (id, id_cerere, data, observatii, id_stare, creat_de,id_user) values (diverse_seq.nextval, " + idCerere + ", sysdate, 'depunere automata', 1, '" + ((diverse)Application.Session.diverse).user.nume + "'," + idUser + ")";
            utils.ExecuteSQL(cmd, false);
            if (utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(utils.lastError, "Eroare 1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //generam raspunsul
            idFisier = utils.ExecuteAndReturnData("select diverse_seq.nextval from dual");
            nf = System.IO.Path.Combine(cale, idFisier + "_raspunsBEJ_nesemnat.pdf");

            ShowWait("Generare raspuns...");
            //generam fisierul nf.... TODO am listaCNP completata
            //test
            //System.IO.File.Copy(System.IO.Path.Combine(cale, "testbej.pdf"), nf);

            //string urlRaport = "http://serv-oracle:7778/reports/rwservlet?destype=cache&desformat=pdf&report=r_raspuns_bej.rdf&userid=localtax/obibubu@server&paramform=no&copies=1&P_nr_cerere=1&P_listaCNP=";
            //urlRaport += listaCNP;
            string urlRaport = "http://serv-oracle:7778/reports/rwservlet?destype=cache&desformat=pdf&report=r_raspuns_bej_dosar.rdf&userid=localtax/obibubu@server&paramform=no&copies=1&P_nr_cerere=1";
            urlRaport += "&P_listaCNP=" + listaCNP1;
            urlRaport += "&P_listaDosar=" + listaDosare1;
            System.Net.WebClient wc = new System.Net.WebClient();
            wc.DownloadFile(urlRaport, nf);


            if(utils.GetParamValue("semnare_raspuns_bej","1")=="1")
            {
                //il semnam cu sigiliul
                ShowWait("Semnare raspuns...");
                string tt = zagar.certsign.SignPDFSigiliu(nf, System.IO.Path.Combine(cale, idFisier + "_raspunsBEJ.pdf"));
                if (tt != "OK")
                {
                    HideWait();
                    MessageBox.Show(tt, "Eroare semnare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
            }
            else
            {
                System.IO.File.Copy(nf, System.IO.Path.Combine(cale, idFisier + "_raspunsBEJ.pdf"));
            }


            //comentat pentru teste
            System.IO.File.Delete(nf);

            nf = System.IO.Path.Combine(cale, idFisier + "_raspunsBEJ.pdf");

            //inserare actiune raspuns, cu fisierul rezultat
            cmd = "insert into fisiere (id, nume, date_created, created_by, rol,campuri) values (" + idFisier + ", '" + idFisier + "_raspunsBEJ.pdf" + "', sysdate, '" + ((diverse)Application.Session.diverse).user.nume + "', '" + ((diverse)Application.Session.diverse).user.rol + "',null)";
            utils.ExecuteSQL(cmd, false);
            if (utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(utils.lastError, "Eroare 2", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            cmd = "insert into cereri_actiuni (id, id_cerere, data, observatii, id_stare, creat_de,id_user,id_fisier) values (diverse_seq.nextval, " + idCerere + ", sysdate, 'finalizare automata', 4, '" + ((diverse)Application.Session.diverse).user.nume + "'," + idUser + "," + idFisier + ")";
            utils.ExecuteSQL(cmd, false);
            if (utils.lastError != "")
            {
                System.IO.File.Delete(nf);
                HideWait();
                MessageBox.Show(utils.lastError, "Eroare 1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //trimitere fisier inapoi la client
            ShowWait("Descarcare raspuns...");
            MemoryStream ms = new MemoryStream();
            using (FileStream file = new FileStream(nf, FileMode.Open, FileAccess.Read)) file.CopyTo(ms);
            ms.Seek(0, SeekOrigin.Begin);
            Application.Download(ms, "raspunsBEJ.pdf");
            HideWait();
            //si aici gata
            this.Close();
        }

        private void cmdDownloadCerere_Click(object sender, EventArgs e)
        {
            string cale = ((diverse)Application.Session.diverse).templateDirectory;
            string fn = "cerere_bej.pdf";
            string nf = System.IO.Path.Combine(cale, fn);
            if (!System.IO.File.Exists(nf))
            {
                MessageBox.Show("Nu exista fisierul " + fn + "!", "Eroare", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            string rol = "";
            if (rol == "") rol = ((diverse)Application.Session.diverse).user.rol;
            string cui = utils.ExecuteAndReturnData("select min(cui) from v_roluri where rol='" + rol + "'");
            string semnatura = utils.ExecuteAndReturnData("select semnatura from semnaturi where id_user='" + ((diverse)Application.Session.diverse).user.id + "'");

            using (MemoryStream ms = new MemoryStream())
            {
                iTextSharp.text.pdf.PdfReader p = new iTextSharp.text.pdf.PdfReader(nf);
                using (PdfStamper pdfStamper = new PdfStamper(p, ms, '\0', true))
                {
                    var r = utils.ExecuteSQL("select nume from CAMPURI_TEMPLATE", true);
                    while (r.Read())
                    {
                        string cmd = "select get_solicitant('" + cui + "','" + semnatura + "','" + r[0].ToString() + "') from dual";
                        string valcamp = utils.ExecuteAndReturnData(cmd);
                        pdfStamper.AcroFields.SetField(r[0].ToString(), valcamp);
                        pdfStamper.AcroFields.SetField(r[0].ToString().ToLower(), valcamp);
                        pdfStamper.AcroFields.SetField(zagar.utils.FirstLetterToUpper(r[0].ToString()), valcamp);
                    }
                }
                MemoryStream ms1 = new MemoryStream(ms.ToArray());//primul se inchide, nu pot folosi decat ms.ToArray()
                Application.Download(ms1, fn);
            }
            try { zagar.utils.Log(((diverse)Application.Session.diverse).user.cont, "Descarcare template cerere BEJ", 4); } catch { }
        }

        private void cmdExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
