using System.Collections.Specialized;
using System.IO;
using System.Text.Json;
using Wisej.AzureAdSample.Services;
using Wisej.Web;

namespace Wisej.AzureAdSample
{
	internal static class Program
	{
		static Program()
		{
			var text = File.ReadAllText(Application.MapPath("Secrets.json"));
			var document = JsonDocument.Parse(text);
			var azureAd = document.RootElement.GetProperty("azureAd");

			var tenantId = "common";
			if (azureAd.TryGetProperty("tenantId", out var tenantIdValue) && tenantIdValue.ValueKind == JsonValueKind.String)
				tenantId = tenantIdValue.GetString();

			Application.Services.AddService<AzureAdService>((t) =>
			{
				string scope = null;
				if (azureAd.TryGetProperty("scope", out var scopeValue) && scopeValue.ValueKind == JsonValueKind.String)
					scope = scopeValue.GetString();

				return new AzureAdService(
					tenantId,
					azureAd.GetProperty("clientId").GetString(),
					azureAd.GetProperty("clientSecret").GetString(),
					scope);
			});
		}

		public static void ApplicationMain(NameValueCollection args)
		{
			new AzureAdDemoForm().Show();
		}
	}
}
