using System;
using System.Text;
using Wisej.AzureAdSample.Models;
using Wisej.AzureAdSample.Services;
using Wisej.Web;

namespace Wisej.AzureAdSample
{
	public class AzureAdDemoForm : Form
	{
		private readonly AzureAdService _azureAdService;
		private readonly Button _buttonLogin;
		private readonly Button _buttonGetUser;
		private readonly Button _buttonSignOut;
		private readonly TextBox _textOutput;

		public AzureAdDemoForm()
		{
			_azureAdService = Application.Services.GetService<AzureAdService>();

			Text = "Azure AD Login (Sample)";
			Width = 900;
			Height = 600;

			_buttonLogin = new Button
			{
				Text = "Login",
				Dock = DockStyle.Top,
				Height = 40
			};
			_buttonLogin.Click += async (s, e) =>
			{
				try
				{
					var ok = await _azureAdService.LoginAsync();
					AppendLine(ok ? "Login OK." : "Login failed.");
				}
				catch (Exception ex)
				{
					AppendLine(ex.ToString());
					AlertBox.Show(ex.Message, MessageBoxIcon.Error);
				}
			};

			_buttonGetUser = new Button
			{
				Text = "Get User Info (/me)",
				Dock = DockStyle.Top,
				Height = 40
			};
			_buttonGetUser.Click += async (s, e) =>
			{
				try
				{
					var user = await _azureAdService.GetCurrentUserAsync();
					AppendUser(user);
				}
				catch (Exception ex)
				{
					AppendLine(ex.ToString());
					AlertBox.Show(ex.Message, MessageBoxIcon.Error);
				}
			};

			_buttonSignOut = new Button
			{
				Text = "Sign Out",
				Dock = DockStyle.Top,
				Height = 40
			};
			_buttonSignOut.Click += (s, e) =>
			{
				_azureAdService.SignOut();
				AppendLine("Signed out.");
			};

			_textOutput = new TextBox
			{
				Dock = DockStyle.Fill,
				Multiline = true,
				ReadOnly = true,
				ScrollBars = ScrollBars.Vertical
			};

			Controls.Add(_textOutput);
			Controls.Add(_buttonSignOut);
			Controls.Add(_buttonGetUser);
			Controls.Add(_buttonLogin);

			AppendLine("Configure Azure AD in Secrets.json and click Login.");
		}

		private void AppendUser(AzureAdUser user)
		{
			if (user == null)
			{
				AppendLine("User: <null>");
				return;
			}

			var sb = new StringBuilder();
			sb.AppendLine("User:");
			sb.AppendLine($"  Id: {user.Id}");
			sb.AppendLine($"  DisplayName: {user.DisplayName}");
			sb.AppendLine($"  GivenName: {user.GivenName}");
			sb.AppendLine($"  Surname: {user.Surname}");
			sb.AppendLine($"  Mail: {user.Mail}");
			sb.AppendLine($"  UPN: {user.UserPrincipalName}");

			AppendLine(sb.ToString().TrimEnd());
		}

		private void AppendLine(string text)
		{
			if (_textOutput.TextLength > 0)
				_textOutput.AppendText(Environment.NewLine);

			_textOutput.AppendText(text);
		}
	}
}
