﻿using System;
using System.Data;
using Wisej.Web;

namespace Transpose1
{
    public partial class Page1 : Page
    {
        private DataTable table;
        private DataGridView dataGridView1;
        private FlowLayoutPanel flowLayoutPanel1;
        private Button buttonToggle;
        public Page1()
        {
            InitializeComponent();
            InitData();
            InitUI();
        }
        private void InitData()
        {
            table = new DataTable();
            table.Columns.Add("ID", typeof(int));
            table.Columns.Add("Name", typeof(string));
            table.Columns.Add("Age", typeof(int));
            table.Columns.Add("Country", typeof(string));

            table.Rows.Add(1, "Alice", 30, "USA");
            table.Rows.Add(2, "Bob", 25, "UK");
            table.Rows.Add(3, "Charlie", 28, "Canada");
        }

        private void InitUI()
        {
            this.Text = "Dynamic Layout Switch";

            dataGridView1 = new DataGridView()
            {
                Dock = DockStyle.Fill,
                DataSource = table
            };

            flowLayoutPanel1 = new FlowLayoutPanel()
            {
                Dock = DockStyle.Fill,
                FlowDirection = FlowDirection.TopDown,
                AutoScroll = true,
                Visible = false
            };

            buttonToggle = new Button()
            {
                Text = "Switch Layout",
                Dock = DockStyle.Top
            };
            buttonToggle.Click += ButtonToggle_Click;

            this.Controls.Add(dataGridView1);
            this.Controls.Add(flowLayoutPanel1);
            this.Controls.Add(buttonToggle);
        }

        private void ButtonToggle_Click(object sender, EventArgs e)
        {
            if (dataGridView1.Visible)
            {
                // Show all rows vertically
                ShowVertical(table);

                dataGridView1.Visible = false;
                flowLayoutPanel1.Visible = true;
            }
            else
            {
                flowLayoutPanel1.Visible = false;
                dataGridView1.Visible = true;
            }
        }

        private void ShowVertical(DataTable table)
        {
            flowLayoutPanel1.Controls.Clear();

            foreach (DataRow row in table.Rows)
            {
                var recordPanel = new FlowLayoutPanel()
                {
                    FlowDirection = FlowDirection.TopDown,
                    AutoSize = true,
                    Width = 300,
                    BorderStyle = BorderStyle.Solid
                };

                foreach (DataColumn col in row.Table.Columns)
                {
                    var line = new FlowLayoutPanel()
                    {
                        FlowDirection = FlowDirection.LeftToRight,
                        AutoSize = true,
                        Width = 280
                    };

                    var label = new Label()
                    {
                        Text = col.ColumnName + ":",
                        Width = 80
                    };

                    var value = new Label()
                    {
                        Text = row[col].ToString(),
                        Width = 180
                    };

                    line.Controls.Add(label);
                    line.Controls.Add(value);

                    recordPanel.Controls.Add(line);
                }

                flowLayoutPanel1.Controls.Add(recordPanel);
            }
        }

    }
}