﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Drawing;
using Wisej.Web;

namespace DataRepeaterSample2
{
	public partial class Page1 : Page
	{
		BindingList<Person> persons;

		public Page1()
		{
			InitializeComponent();
		}

		private void Page1_Load(object sender, EventArgs e)
		{
			persons = new BindingList<Person>();
			persons.Add(new Person("Peter", 1));
			persons.Add(new Person("Paul", 2));
			persons.Add(new Person("Mary", 3));

			this.dataRepeater1.DataSource = persons;
		}

        private void dataRepeater1_ItemUpdate(object sender, DataRepeaterItemEventArgs e)
        {
			var item = e.DataRepeaterItem;

			if (item != null)
			{
				var txtName = item.Controls.Find("txtName", true).FirstOrDefault();
				if (txtName != null)
				{
					if (txtName.Text == "Paul")
						txtName.ForeColor = Color.Blue;
				}
			}
        }

        private void btnShowID_Click(object sender, EventArgs e)
        {
			var button = sender as Button;

			if (button != null)
			{
				AlertBox.Show("You clicked on ID " + button.Tag.ToString());
			}
        }
    }
}
